IF EXISTS( SELECT 1 FROM SYS.VIEWS WHERE  OBJECT_ID = OBJECT_ID(N'[DBO].[V_EST_NF_ENT]') )
DROP VIEW [DBO].[V_EST_NF_ENT];
GO
CREATE VIEW [DBO].[V_EST_NF_ENT]
WITH ENCRYPTION
AS
	-- VERSAO 28092022
	 SELECT
			DBO.EST_NF_ENT_IT.CD_EMP
		  , DBO.EST_NF_ENT_IT.CD_FILIAL
		  , DBO.EST_NF_ENT_IT.CD_NF
		  , ISNULL(DBO.EST_NF_ENT_PED_CP.CD_PED, 0) AS CD_PED
		  , DBO.EST_NF_ENT.NR_NF
		  , DBO.EST_NF_ENT.CD_NF_SERIE
		  , ISNULL(DBO.EST_NF_SERIE.SERIE, '') AS SERIE
		  , ISNULL(DBO.EST_NF_SERIE.MODELO, '') AS MODELO
		  , DBO.EST_NF_ENT.CD_FORN AS CD_ORIG
		  ,  V_GLB_PESSOA.RAZAO_SOCIAL_PESSOA	AS NM_ORIG
		  ,  V_GLB_PESSOA.NOME_FANTASIA_PESSOA  AS NM_ORIG_FANT
		  ,  V_GLB_PESSOA.CGC_CPF				AS CGC_CPF
		  ,  V_GLB_PESSOA.INSC_EST				AS INSC_EST
		  ,  V_GLB_PESSOA.TP_SUBS_TRIB			AS TP_SUBS_TRIB
		  ,  V_GLB_PESSOA.SUBS_TRIB				AS SUBS_TRIB_FORN
		  ,  V_GLB_PESSOA.ENDERECO_PESSOA		AS ENDE
		  ,  V_GLB_PESSOA.NUMERO_ENDERECO_PESSOA  AS NUMERO
		  ,  V_GLB_PESSOA.BAIRRO_ENDERECO_PESSOA  AS BAIRRO
		  ,  V_GLB_PESSOA.CEP_ENDERECO_PESSOA	AS CEP
		  ,  V_GLB_PESSOA.TELEFONE_PESSOA		AS TEL
		  ,  V_GLB_PESSOA.CD_CID				AS CD_CID
		  ,  V_GLB_PESSOA.COD_IBGE_MUNICIPIO	AS COD_IBGE
		  ,  V_GLB_PESSOA.DS_CID				AS DS_CID
		  ,  V_GLB_PESSOA.FLAG_ICMS_SUBST_PAGO_ANTERIOR AS FLAG_ICMS_SUBST_PAGO_ANTERIOR
		  ,  V_GLB_PESSOA.UF AS UF
		  ,  V_GLB_PESSOA.FLAG_VALIDA_NFE			AS FLAG_VALIDA_NFE
		  ,  V_GLB_PESSOA.DS_TIPO_PESSOA			AS TIPO_FORNECEDOR
		  ,  V_GLB_PESSOA.FLAG_SIMPLES_NACIONAL		AS FLAG_MICRO_EMPRESA
		  ,  V_GLB_PESSOA.CD_TIPO_PESSOA			AS CD_TP_FORN
		  ,  V_GLB_PESSOA.QTDE_CASAS_DECIMAIS_NOTA  AS QTDE_CASAS_DECIMAIS_NOTA
		  ,  V_GLB_PESSOA.CONTRIBUINTE				AS CONTRIBUINTE
		  , DBO.EST_NF_ENT_IT.DT_ENT
		  , DBO.EST_NF_ENT.DT_EMI_NF
		  , DBO.EST_NF_ENT.HR_EMI_NF
		  , DBO.EST_NF_ENT.VLR_NF
		  , DBO.EST_NF_ENT.VLR_TOT_PROD
		  , DBO.EST_NF_ENT.VLR_BASE_ICMS
		  , DBO.EST_NF_ENT.VLR_ICMS
		  , DBO.EST_NF_ENT.VLR_BASE_ICMS_SUBS
		  , DBO.EST_NF_ENT.VLR_ICMS_SUBS
		  , DBO.EST_NF_ENT.VLR_FRETE
		  , CASE
				WHEN EST_NF_ENT.VLR_FRETE = 0 THEN 0
				ELSE CASE
						 WHEN CONVERT(FLOAT, EST_NF_ENT.VLR_NF - EST_NF_ENT.VLR_FRETE) > 0 THEN 
							ROUND((ROUND((CONVERT(FLOAT, EST_NF_ENT.VLR_FRETE) / CONVERT(FLOAT, EST_NF_ENT.VLR_NF - EST_NF_ENT.VLR_FRETE)), 9) 
								* (ROUND(((EST_NF_ENT_IT.QT_IT * EST_NF_ENT_IT.VLR_IT) - EST_NF_ENT_IT.VLR_DESC), 2) + EST_NF_ENT_IT.VLR_IPI + EST_NF_ENT_IT.VLR_ICMS_SUBS)), 2)
						 ELSE 0
					 END
			END AS VLR_FRETE_CABE_RATEIO
		  , DBO.EST_NF_ENT.VLR_DESC AS VLR_DESC_CAB
		  , DBO.EST_NF_ENT.VLR_DESC_CAB AS VLR_DESC_CAB_ARRED
		  , DBO.EST_NF_ENT.VLR_PERC_IPI_FRETE
		  , DBO.EST_NF_ENT.PERC_IPI_FRETE
		  , EST_NF_ENT.TP_FRETE
		  , DBO.EST_NF_ENT.VLR_IPI
		  , DBO.EST_NF_ENT.VLR_OUTROS
		  , DBO.EST_NF_ENT.VRL_ISENTAS
		  , DBO.EST_NF_ENT.VLR_ENCG_FIN
		  , DBO.EST_NF_ENT.PERC_ICMS_ENCG_FIN
		  , DBO.EST_NF_ENT.HIST AS OBS1
		  , DBO.EST_NF_ENT.HIST2 AS OBS2
		  , DBO.EST_NF_ENT.DT_ENTRADA_EST
		  , 0 AS VLR_OUTRAS_DESP
		  , '' AS OBS3
		  , DBO.EST_NF_ENT.OBS4
		  , DBO.EST_NF_ENT.OBS5
		  , '' AS OBS6
		  , '' AS OBS7
		  , '' AS NM_COMPRADOR
		  , DBO.EST_NF_ENT.INF_DESCONTO
		  , DBO.EST_NF_ENT.DT_CAD
		  , DBO.EST_NF_ENT.CD_USU
		  , DBO.EST_NF_ENT.STS_NF
		  , DBO.EST_NF_ENT.DS_TRANSP
		  , DBO.EST_NF_ENT.PLACA_VEIC
		  , DBO.EST_NF_ENT.PLACA_UF
		  , DBO.EST_NF_ENT.ENCG_TRIB
		  , DBO.EST_NF_ENT.CGC_CPF_TRANSP
		  , DBO.EST_NF_ENT.ENDE_TRANSP
		  , DBO.EST_NF_ENT.DS_CID_TRANSP
		  , DBO.EST_NF_ENT.UF_TRANSP
		  , DBO.EST_NF_ENT.INSC_EST_TRANSP
		  , EST_NF_ENT.EMAIL_TRANSP
		  , DBO.EST_NF_ENT.QT_VOL
		  , DBO.EST_NF_ENT.ESPCIE_VOL
		  , DBO.EST_NF_ENT.MC_VOL
		  , DBO.EST_NF_ENT.NR_VOL
		  , DBO.EST_NF_ENT.PESO_BRT
		  , DBO.EST_NF_ENT.PESO_LIQ
		  , DBO.EST_NF_ENT_IT.SEQ_ITEM
		  , DBO.EST_NF_ENT_IT.CD_PROD
		  , DBO.EST_PROD.DS_PROD
		  , DBO.EST_NF_ENT_IT.UN
		  , DBO.EST_NF_ENT_IT.CD_TRIB
		  , DBO.EST_TRIB.CD_TRIB_FC
		  , ISNULL(DBO.EST_TRIB.TRIB_FC_ELETRONICO, '') TRIB_FC_ELETRONICO
		  , DBO.EST_NF_ENT_IT.QT_IT
		  , COALESCE(EST_NF_ENT_IT.VLR_IT,CONVERT(FLOAT, EST_NF_ENT_IT.VLR_TOT_IT) / CONVERT(FLOAT,
															   CASE
																   WHEN EST_NF_ENT_IT.QT_IT = 0 THEN 1
																   ELSE EST_NF_ENT_IT.QT_IT
															   END)) AS VLR_IT
		  , CASE
				WHEN ISNULL(DBO.EST_NF_ENT.FLAG_NF_PROD_TOTAL_BRUTO, 0) = 0 THEN ROUND((EST_NF_ENT_IT.VLR_IT * EST_NF_ENT_IT.QT_IT),2)
				ELSE ROUND((EST_NF_ENT_IT.VLR_IT * EST_NF_ENT_IT.QT_IT),2) - EST_NF_ENT_IT.VLR_DESC
			END AS VLR_TOT_IT
		  , DBO.EST_NF_ENT_IT.ALIQ_ICMS
		  , DBO.EST_NF_ENT_IT.VLR_BASE_ICMS AS VLR_BASE_ICMS_IT
		  , DBO.EST_NF_ENT_IT.VLR_ICMS_IT
		  , DBO.EST_NF_ENT_IT.VLR_IPI AS VLR_IPI_IT
		  , DBO.EST_NF_ENT_IT.PERC_IVA
		  , DBO.EST_NF_ENT_IT.VLR_BASE_SUBS AS VLR_BASE_SUBS_IT
		  , DBO.EST_NF_ENT_IT.VLR_ICMS_SUBS AS VLR_ICMS_SUBS_IT
		  , DBO.EST_NF_ENT_IT.CD_NT_OP
		  , DBO.EST_NF_ENT_IT.VLR_PRC_CUSTO
		  , ISNULL(DBO.EST_NF_ENT_IT.VLR_CUSTO_MD, 0) VLR_CUSTO_MD
		  , DBO.EST_NF_ENT_IT.VLR_PRC_CUSTO_ANT
		  , DBO.EST_NF_ENT_IT.VLR_ISENTO AS VLR_ISENTO_IT
		  , DBO.EST_NF_ENT_IT.VLR_OUTROS AS VLR_OUTROS_IT
		  , CASE
				WHEN EST_NF_ENT.VLR_OUTROS = 0 THEN 0
				ELSE CASE
						 WHEN CONVERT(FLOAT, EST_NF_ENT.VLR_NF - EST_NF_ENT.VLR_OUTROS) > 0 THEN ROUND((ROUND((CONVERT(FLOAT, EST_NF_ENT.VLR_OUTROS) / CONVERT(FLOAT, EST_NF_ENT.VLR_NF - EST_NF_ENT.VLR_OUTROS)), 9) * (ROUND(((EST_NF_ENT_IT.QT_IT * EST_NF_ENT_IT.VLR_IT) - EST_NF_ENT_IT.VLR_DESC), 2) + EST_NF_ENT_IT.VLR_IPI + EST_NF_ENT_IT.VLR_ICMS_SUBS)), 2)
						 ELSE 0
					 END
			END AS VLR_OUTROS_CABE_RATEIO
		  , DBO.EST_NF_ENT_IT.PERC_DESC
		  , DBO.EST_NF_ENT_IT.VLR_DESC AS VLR_DESC_IT
		  , DBO.EST_NF_ENT_IT.PERC_IPI
		  , DBO.GLB_NT_OP.CD_NT_OP_FC AS CFOP
		  , DBO.GLB_MOV_OP.CD_MOV_OP
		  , DBO.GLB_MOV_OP.TP_MOV_OP_TRANSA
		  , DBO.GLB_MOV_OP.DS_MOV_OP
		  , DBO.GLB_MOV_OP.DS_MOV_OP_USUAL
		  , DBO.GLB_MOV_OP.TP_MOV
		  , DBO.GLB_MOV_OP.ATU_EST
		  , DBO.GLB_NT_OP.CD_CTB_CNT_RED
		  , DBO.GLB_NT_OP.CD_CTB_CNT
		  , DBO.GLB_MOV_OP.DEST_ORIG
		  , DBO.EST_NF_ENT_IT.PIS_COFINS
		  , DBO.EST_NF_ENT.PGTO_VISTA_PRAZO
		  , DBO.GLB_MOV_OP.TP_ESTQ
		  , DBO.GLB_MOV_OP.ENVIO_OPERADOR_LOG
		  , DBO.GLB_MOV_OP.FLAG_RETORNO_OPERADOR_LOG
		  , DBO.GLB_MOV_OP.FLAG_ENTRADA_OPERADOR_LOG
		  , DBO.EST_NF_ENT.NR_SELO_SAIDA
		  , TP_LAYOUT_EXP_ENT
		  , ISNULL(DBO.EST_NF_ENT.NR_PED_FORN, '') AS NR_PED_FORN
		  , L.DS_SIGLA_LINHA
		  , DBO.EST_NF_ENT.NR_FORMULARIO
		  , DBO.EST_TRIB.ICMS
		  , DBO.EST_TRIB.SUBS_TRIB
		  , DBO.EST_TRIB.ICMS_RD
		  , DBO.EST_TRIB.SUBS_TRIB_ANT
		  , DBO.EST_TRIB.ISENTO
		  , DBO.EST_PROD.NR_NCM
		  , ISNULL(EST_NF_ENT_IT.LISTA_PROD, 0) AS LISTA_PROD
		  , EXPORT_NF_ESCRITA
		  , DBO.EST_PROD.CTR_LOTE
		  , ISNULL(DBO.EST_PROD.CONTROLE_SNGPC, 0) AS CONTROLE_SNGPC
		  , DBO.GLB_MOV_OP.FLAG_NAO_CROSS_DOCKING
		  , ISNULL(FF.CD_EMP, 0) AS CD_FORN_FILIAL
		  , DBO.EST_NF_ENT.CD_FORN
		  , ISNULL(DBO.EST_NF_ENT_IT.PERC_REDU_BASE_SUBS, 0) AS PERC_REDU_BASE_SUBS_IT
		  , ISNULL(DBO.EST_NF_ENT_IT.PERC_REDU_BASE_ICMS, 0) AS PERC_REDU_BASE_ICMS_IT
		  , ISNULL(DBO.EST_NF_ENT_IT.VLR_BASE_PIS, 0) AS VLR_BASE_PIS
		  , ISNULL(DBO.EST_NF_ENT_IT.VLR_PIS, 0) AS VLR_PIS
		  , ISNULL(DBO.EST_NF_ENT_IT.PERC_ALIQ_PIS, 0) AS PERC_ALIQ_PIS
		  , ISNULL(DBO.EST_NF_ENT_IT.VLR_BASE_COFINS, 0) AS VLR_BASE_COFINS
		  , ISNULL(DBO.EST_NF_ENT_IT.VLR_COFINS, 0) AS VLR_COFINS
		  , ISNULL(DBO.EST_NF_ENT_IT.PERC_ALIQ_COFINS, 0) AS PERC_ALIQ_COFINS
		  , ISNULL(FLAG_MOV_OP_NFE_CPL, 0) AS FLAG_MOV_OP_NFE_CPL
		  , ISNULL(DBO.EST_NF_ENT_IT.VLR_BASE_ICMS_RET, 0) AS VLR_BASE_ICMS_RET
		  , ISNULL(DBO.EST_NF_ENT_IT.VLR_ICMS_RET, 0) AS VLR_ICMS_RET
		  , ISNULL(DBO.EST_NF_ENT_IT.VLR_OUTRAS_DESPESAS, 0) AS VLR_OUTRAS_DESPESAS
		  , ISNULL(DBO.EST_NF_ENT_IT.VLR_PROD_FRETE, EST_NF_ENT_IT.VLR_FRETE_IT) AS VLR_PROD_FRETE
		  , ISNULL(DBO.EST_NF_ENT_IT.VLR_PROD_PMC, 0) AS VLR_PROD_PMC
		  , CASE
				WHEN ISNULL(DBO.EST_NF_ENT_IT.CD_SIT_OPERA_SIMPLES_NACIO, 0) = 0 THEN CASE
																						  WHEN ISNULL(EST_TRIB.TIPO_REGIME_EMPRESA, 0) = 1 THEN DBO.EST_TRIB.CD_TRIB_FC
																						  ELSE ISNULL(DBO.EST_NF_ENT_IT.CD_SIT_OPERA_SIMPLES_NACIO, 0)
																					  END
				ELSE ISNULL(DBO.EST_NF_ENT_IT.CD_SIT_OPERA_SIMPLES_NACIO, 0)
			END AS CD_SIT_OPERA_SIMPLES_NACIO
		  , ISNULL(DBO.EST_NF_ENT_IT.MODALI_BASE_ICMS_SUBST, 0) AS MODALI_BASE_ICMS_SUBST
		  , ISNULL(DBO.EST_NF_ENT_IT.MODALI_BASE_ICMS, 0) AS MODALI_BASE_ICMS
		  , ISNULL(DBO.EST_NF_ENT_IT.VLR_CRED_BASE_SN, 0) AS VLR_CRED_BASE_SN
		  , ISNULL(DBO.EST_NF_ENT_IT.VLR_CRED_ICMS_SN, 0) AS VLR_CRED_ICMS_SN
		  , ISNULL(DBO.EST_NF_ENT_IT.VLR_IMPOSTO_REA, 0) AS VLR_IMPOSTO_REA
		  , ISNULL(DBO.EST_NF_ENT.FLAG_NF_PROD_TOTAL_BRUTO, 0) AS FLAG_NF_PROD_TOTAL_BRUTO
		  , V_GLB_PESSOA.ENVIAR_XML_NFE
		  , V_GLB_PESSOA.EMAIL_PESSOA AS EMAIL
		  , EST_NF_SERIE.ESPC
		  , EST_NF_ENT.IMP_NF
		  , EST_NF_ENT.CD_USU_LIBEROU_CUSTO_VARIACAO
		  , EST_NF_ENT.CD_USU_LIBEROU_DESACORDO
		  , ISNULL(DBO.EST_NF_ENT_IT.CST_PIS, 0) AS CST_PIS
		  , ISNULL(DBO.EST_NF_ENT_IT.CST_COFINS, 0) AS CST_COFINS
		  , EST_NF_ENT.CD_MT_DEV_VD
		  , ISNULL(GLB_MOV_OP.FLAG_NAO_TRIBUTAR_PIS_COFINS, 0) AS FLAG_NAO_TRIBUTAR_PIS_COFINS
		  , CASE
				WHEN FL.REGIME_TRIBUTARIO IN(1, 2) THEN ISNULL(EST_TRIB.CD_TRIB_SIMPLES, 0)
				ELSE ISNULL(EST_TRIB.CD_TRIB_DEVOLUCAO, 0)
			END AS CD_TRIB_DEVOLUCAO
		  , ISNULL(EST_TRIB.FLAG_VLR_SUBST_TOTAL_PROD, 0) AS FLAG_VLR_SUBST_TOTAL_PROD
		  , ISNULL(EST_NF_ENT_IT.PERC_DESC_FINAN, 0) AS PERC_DESC_FINAN
		  , ROUND(ISNULL((CASE
							  WHEN ISNULL(DBO.EST_NF_ENT.FLAG_NF_PROD_TOTAL_BRUTO, 0) = 0 THEN(EST_NF_ENT_IT.VLR_TOT_IT + EST_NF_ENT_IT.VLR_FRETE_IT)
							  ELSE(EST_NF_ENT_IT.VLR_TOT_IT + EST_NF_ENT_IT.VLR_ICMS_SUBS + EST_NF_ENT_IT.VLR_IPI + EST_NF_ENT_IT.VLR_FRETE_IT) - EST_NF_ENT_IT.VLR_DESC
						  END) * (EST_NF_ENT_IT.PERC_DESC_FINAN / 100), 0), 2) AS VLR_DESC_FINAN_PROD
		  , ROUND(ISNULL((CASE
							  WHEN ISNULL(DBO.EST_NF_ENT.FLAG_NF_PROD_TOTAL_BRUTO, 0) = 0 THEN(EST_NF_ENT_IT.VLR_TOT_IT + EST_NF_ENT_IT.VLR_ICMS_SUBS + EST_NF_ENT_IT.VLR_IPI + EST_NF_ENT_IT.VLR_FRETE_IT)
							  ELSE(EST_NF_ENT_IT.VLR_TOT_IT + EST_NF_ENT_IT.VLR_ICMS_SUBS + EST_NF_ENT_IT.VLR_IPI + EST_NF_ENT_IT.VLR_FRETE_IT) - EST_NF_ENT_IT.VLR_DESC
						  END) * (EST_NF_ENT_IT.PERC_DESC_FINAN / 100), 0) / CASE
																				 WHEN EST_NF_ENT_IT.QT_IT = 0 THEN 1
																				 ELSE EST_NF_ENT_IT.QT_IT
																			 END, 2) AS VLR_DESC_FINAN_PROD_UNIT
		  , ISNULL(FRETE_INCIDE_BASE_ICMS, 0) AS FRETE_INCIDE_BASE_ICMS
		  , ISNULL(EST_NF_ENT_IT.ALIQ_ICMS_INTERNO, 0) AS ALIQ_ICMS_INTERNO
		  , EST_NF_SERIE.TP_SR_NFE
		  , EST_NF_ENT.HR_ENT
		  , ISNULL(EST_NF_ENT_IT.QT_EMB, 0) AS QT_EMB
		  , ISNULL(EST_NF_ENT.FLAG_N_GERAR_DAR, 0) AS FLAG_N_GERAR_DAR
		  , ISNULL(EST_NF_ENT_IT.FLAG_N_GERAR_DAR, 0) AS FLAG_N_GERAR_DAR_IT
		  , ISNULL(APLICATIVO, '') AS APLICATIVO
		  , ISNULL(VERSAO_APLICATIVO, '') AS VERSAO_APLICATIVO
		  , ISNULL(EST_NF_ENT_IT.PIS_COFINS_RECALCULADO, 0) AS PIS_COFINS_RECALCULADO
		  , ISNULL(EST_NF_ENT_IT.TIPO_TRIBUTACAO_PIS_COFINS, 0) AS TIPO_TRIBUTACAO_PIS_COFINS
		  , GLB_NT_OP.DS_NT_OP
		  , EST_PROD.CTR_PMC
		  , FL.FLAG_OPERADOR_LOG
		  , ISNULL(GLB_MOV_OP.FLAG_NAO_GERAR_ARQ_SPED, 0) AS FLAG_NAO_GERAR_ARQ_SPED
		  , NFE.NR_AUTORIZADOR
		  , NFE.NR_PROTOCOLO
		  , NFE.VS_PROTOCOLO
		  , NFE.DT_RECBTO
		  , NFE.DG_VALIDADOR
		  , NFE.TP_AMB
		  , NFE.VS_APLIC
		  , NFE.REG_CONTG
		  , NFE_CANCEL.NR_PROTOCOLO AS NR_PROTOCOLO_CANCEL
		  , NFE_CANCEL.JUSTIFICATIVA AS JUSTIFICA_CANCEL
		  , EST_NF_ENT_IT.VLR_DESC_FINAN
		  , EST_TRIB.TIPO_REGIME_EMPRESA
		  , ISNULL(EST_NF_ENT_DAR_IT.VLR_ICMS_SUBS, 0) AS VLR_ICMS_SUBS_DARE
		  , ISNULL(EST_NF_ENT_DAR_IT.VLR_ICMS_DIFERENCIAL, 0) AS VLR_ICMS_DIFERENCIAL_ALIQUOTA
		  , ISNULL(EST_TRIB.ORIGEM_PRODUTO, 0) AS ORIGEM_PRODUTO
		  , ISNULL(FLAG_CUSTO_ZERO_ENT, 0) AS FLAG_CUSTO_ZERO_ENT
		  , ISNULL(VLR_CUSTO_GERENCIAL_TRANSF, 0) AS VLR_CUSTO_GERENCIAL_TRANSF
		  , ISNULL(EST_NF_ENT_IT.VLR_BASE_ICMS_OP, 0) AS VLR_BASE_ICMS_OP
		  , ISNULL(EST_NF_ENT_IT.VLR_ICMS_OP, 0) AS VLR_ICMS_OP
		  , ISNULL(EST_NF_ENT_IT.VLR_CUSTO_ANT_RECALC, 0) AS VLR_CUSTO_ANT_RECALC
		  , CASE
				WHEN FL.FLAG_FATURAMENTO_AUTOMATICO_HABILITADO = 0 THEN 'NAO'
				WHEN FL.FLAG_FATURAMENTO_AUTOMATICO_HABILITADO = 1 THEN 'SOMENTE PRE-FATURA'
				WHEN FL.FLAG_FATURAMENTO_AUTOMATICO_HABILITADO = 2 THEN 'TODOS OS PROCESSOS'
			END AS FLAG_FATURAMENTO_AUTOMATICO_HABILITADO
		  , CASE
				WHEN FL.FLAG_NOTA_FISCAL_ENTRADA_AUTOMATICA = 0 THEN 'NAO'
				WHEN FL.FLAG_NOTA_FISCAL_ENTRADA_AUTOMATICA = 1 THEN 'SIM'
			END AS FLAG_NOTA_FISCAL_ENTRADA_AUTOMATICA
		  , ISNULL(NFE_DENEGADA.CD_NF, 0) AS NFE_DENEGADA
		  , CASE
				WHEN ISNULL(EST_NF_ENT_EF_NF_CTR_NF.CD_NF_ENT, 0) > 0 THEN 1
				ELSE 0
			END FLAG_NOTA_EMISSAO_PROPRIA
		  , ISNULL(EST_TRIB.FLAG_OUTROS, 0) AS FLAG_OUTROS
		  , ISNULL(EST_NF_ENT_IT.PERC_ICMS_OP, 0) AS PERC_ICMS_OP
		  , ISNULL(EST_NF_ENT_IT.PERC_IVA_RET, 0) AS PERC_IVA_RET
		  , ISNULL(EST_NF_ENT_IT.PERC_ICMS_RET, 0) AS PERC_ICMS_RET
		  , EST_NF_ENT_IT.VLR_TOT_IT + ISNULL(EST_NF_ENT_IT.VLR_FRETE_IT, 0) + CASE
																				   WHEN DBO.EST_TRIB.SUBS_TRIB = 1 THEN EST_NF_ENT_IT.VLR_ICMS_SUBS
																				   ELSE 0
																			   END + ISNULL(EST_NF_ENT_IT.VLR_OUTRAS_DESPESAS, 0) + ISNULL(EST_NF_ENT_IT.VLR_IPI, 0) + CASE
																																										   WHEN V_GLB_PESSOA.FLAG_ICMS_SUBST_PAGO_ANTERIOR = 0 THEN ISNULL(EST_NF_ENT_IT.VLR_ICMS_RET, 0)
																																										   ELSE 0
																																									   END - ISNULL(EST_NF_ENT_IT.VLR_DESC, 0) VLR_IT_TOT_NF
		  , EST_NF_ENT_IT.VLR_RESSARCIMENTO_ICMS
		  , CASE
				WHEN GLB_MOV_OP.GERA_ICMS_SUBS = 0 THEN 'SIM'
				ELSE 'NAO'
			END AS GERA_MOV_ICMS_SUBS
		  , CASE
				WHEN GLB_MOV_OP.ALQ_ICMS = 0 THEN 'SIM'
				ELSE 'NAO'
			END AS GERA_MOV_ICMS
		  , ISNULL(EST_NF_ENT_IT.VLR_ICMS_DESONERADO, 0) AS VLR_ICMS_DESONERADO
		  , ISNULL(EST_NF_ENT.VLR_ICMS_DESONERADO, 0) AS VLR_ICMS_DESONERADO_CAB
		  , GLB_MOV_OP.TP_PRECO
                  , EST_NF_ENT_IT.ICMS_DESONERADO_MOTIVO 
		  , GLB_MOV_OP.CALC_CUSTO_MEDIO
		  , ISNULL(EST_PROD.NR_CEST, '') NR_CEST
		  , GLB_USU.NM_USU
		  , ISNULL(EST_TRIB.ICMS_DIFERIDO, 0) AS ICMS_DIFERIDO
		  , ISNULL(EST_NF_ENT_IT.PERC_DIFERIMENTO, 0) AS PERC_DIFERIMENTO
		  , ISNULL(EST_NF_ENT_IT.VLR_ICMS_DIFERIMENTO, 0) AS VLR_ICMS_DIFERIMENTO
		  , ISNULL(EST_NF_ENT_IT.VLR_FRETE_IT, 0) AS VLR_FRETE_IT
		  , EST_NF_ENT.DT_HR_CAD
		  , ISNULL(EST_NF_ENT_IT.VLR_BASE_ICMS_LUCRO_REAL, 0) AS VLR_BASE_ICMS_LUCRO_REAL
		  , ISNULL(EST_NF_ENT_IT.PERC_ICMS_LUCRO_REAL, 0) AS PERC_ICMS_LUCRO_REAL
		  , ISNULL(EST_NF_ENT_IT.VLR_ICMS_LUCRO_REAL, 0) AS VLR_ICMS_LUCRO_REAL
		  , ISNULL(FL.REGIME_TRIBUTARIO, 0) AS REGIME_TRIBUTARIO_FILIAL
		  , ISNULL(COD_MUNICIPIO_SINTEGRA, 0) AS COD_IBGE_MUNICIPIO_DESTINATARIO
		  , ISNULL(EST_NF_ENT.END_DESTINATARIO, '') END_DESTINATARIO
		  , ISNULL(EST_NF_ENT.BAIRRO_DESTINATARIO, '') BAIRRO_DESTINATARIO
		  , ISNULL(EST_NF_ENT.CEP_DESTINATARIO, '') CEP_DESTINATARIO
		  , ISNULL(EST_NF_ENT.CIDADE_DESTINATARIO, '') CIDADE_DESTINATARIO
		  , ISNULL(EST_NF_ENT.CNPJ_DESTINATARIO, '') CNPJ_DESTINATARIO
		  , ISNULL(EST_NF_ENT.INSC_ESTADUAL_DESTINATARIO, '') INSC_ESTADUAL_DESTINATARIO
		  , ISNULL(EST_NF_ENT.RZ_DESTINATARIO, '') RZ_DESTINATARIO
		  , ISNULL(EST_NF_ENT.UF_DESTINATARIO, '') UF_DESTINATARIO
		  , ISNULL(EST_NF_ENT.CD_CID_DESTINATARIO, '') CD_CID_DESTINATARIO
		  , ISNULL(FL.TP_REGIME_APURAC_PIS_COFINS, '') TP_REGIME_APURAC_PIS_COFINS
		  , ISNULL(EST_NF_ENT.END_EMITENTE, '') END_EMITENTE
		  , ISNULL(EST_NF_ENT.BAIRRO_EMITENTE, '') BAIRRO_EMITENTE
		  , ISNULL(EST_NF_ENT.CEP_EMITENTE, '') CEP_EMITENTE
		  , ISNULL(EST_NF_ENT.CIDADE_EMITENTE, '') CIDADE_EMITENTE
		  , ISNULL(EST_NF_ENT.CNPJ_EMITENTE, '') CNPJ_EMITENTE
		  , ISNULL(EST_NF_ENT.INSC_ESTADUAL_EMITENTE, '') INSC_ESTADUAL_EMITENTE
		  , ISNULL(EST_NF_ENT.RZ_EMITENTE, '') RZ_EMITENTE
		  , ISNULL(EST_NF_ENT.UF_EMITENTE, '') UF_EMITENTE
		  , ISNULL(EST_NF_ENT_DAR_IT.VLR_BASE_SUBS, '') VLR_BASE_SUBS_DARE
		  , ISNULL(EST_NF_ENT_DAR_IT.PERC_IVA, '') PERC_IVA_DARE
		  , ISNULL(EST_NF_ENT_DAR_IT.PERC_ICMS_DESTINO, '') PERC_ICMS_DESTINO_DARE
		  , ISNULL(EST_NF_ENT.VLR_FECOP_ST, 0) AS VLR_FECOP_ST
		  , ISNULL(EST_NF_ENT_IT.VLR_BASE_FECOP_ST, 0) AS VLR_BASE_FECOP_ST_IT
		  , ISNULL(EST_NF_ENT_IT.VLR_FECOP_ST, 0) AS VLR_FECOP_ST_IT
		  , ISNULL(EST_NF_ENT_IT.PERC_FECOP_ST, 0) AS PERC_FECOP_ST
		  , ISNULL(EST_NF_ENT.VLR_FECOP, 0) AS VLR_FECOP
		  , ISNULL(EST_NF_ENT_IT.VLR_BASE_FECOP, 0) AS VLR_BASE_FECOP_IT
		  , ISNULL(EST_NF_ENT_IT.VLR_FECOP, 0) AS VLR_FECOP_IT
		  , ISNULL(EST_NF_ENT_IT.PERC_FECOP, 0) AS PERC_FECOP
		  , ISNULL(EST_NF_ENT.VLR_FECOP_ST_RET, 0) AS VLR_FECOP_ST_RET
		  , ISNULL(EST_NF_ENT_IT.VLR_BASE_FECOP_RET, 0) AS VLR_BASE_FECOP_RET_IT
		  , ISNULL(EST_NF_ENT_IT.VLR_FECOP_RET, 0) AS VLR_FECOP_RET_IT
		  , ISNULL(EST_NF_ENT_IT.PERC_FECOP_RET, 0) AS PERC_FECOP_RET
		  , ISNULL(V_GLB_PESSOA.COMPLEMENTO_RESIDENCIAL,'') AS COMPLEMENTO_RESIDENCIAL
          , ISNULL(BN.CD_BENEF,'')									AS CD_BENEF
		  , EST_NF_ENT.UUID
		  , ISNULL(EST_NF_ENT_IT.CD_BENEF,'')						AS CD_BENEF_IT
		  , ISNULL(EST_TRIB.FLAG_VLR_FECOP_ST,0)					AS FLAG_VLR_FECOP_ST
		  , ISNULL(EST_NF_ENT_DAR_IT.VLR_PMC,0)						AS VLR_PMC_DAR_IT
		  , ISNULL(EST_NF_ENT_DAR_IT.VLR_PMPF,0)					AS VLR_PMPF_DAR_IT
		  , ISNULL(EST_NF_ENT_DAR_IT.TP_SUBS,0)						AS TP_SUBS_DAR_IT
		  , ISNULL(EST_NF_ENT.FLAG_VLR_ICMS_DESONERADO_DESCONTO,0)	AS FLAG_VLR_ICMS_DESONERADO_DESCONTO
		  , ISNULL(EST_NF_ENT_IT.OBSERVACOES_FISCAIS_CONTRIBUINTE,0)	AS OBS_CONTRIBUINTE
		  , ISNULL(EST_TRIB.FLAG_ACAO_3_DEV_OUTRA_UF,0 ) AS FLAG_ACAO_3_DEV_OUTRA_UF,
			ISNULL(EST_NF_ENT.INSC_SUFRAMA,'') AS INSC_SUFRAMA
	 FROM
		 DBO.EST_NF_ENT
		 INNER JOIN PRC_FILIAL FL ON DBO.EST_NF_ENT.CD_EMP = FL.CD_EMP
									 AND DBO.EST_NF_ENT.CD_FILIAL = FL.CD_FILIAL
		 INNER JOIN DBO.EST_NF_ENT_IT ON DBO.EST_NF_ENT.CD_EMP = DBO.EST_NF_ENT_IT.CD_EMP
										 AND DBO.EST_NF_ENT.CD_FILIAL = DBO.EST_NF_ENT_IT.CD_FILIAL
										 AND DBO.EST_NF_ENT.CD_NF = DBO.EST_NF_ENT_IT.CD_NF
										 AND DBO.EST_NF_ENT.DT_ENT = DBO.EST_NF_ENT_IT.DT_ENT
		 INNER JOIN DBO.EST_PROD ON DBO.EST_PROD.CD_EMP = DBO.EST_NF_ENT_IT.CD_EMP
									AND DBO.EST_PROD.CD_PROD = DBO.EST_NF_ENT_IT.CD_PROD
		 INNER JOIN DBO.GLB_NT_OP ON DBO.EST_NF_ENT_IT.CD_NT_OP = DBO.GLB_NT_OP.CD_NT_OP
		 INNER JOIN DBO.GLB_MOV_OP ON DBO.EST_NF_ENT.CD_NT_MOV = DBO.GLB_MOV_OP.CD_MOV_OP
		  
		 OUTER APPLY UFD_GLB_PESSOA(EST_NF_ENT.CD_FORN, GLB_MOV_OP.DEST_ORIG) V_GLB_PESSOA
		 INNER JOIN DBO.EST_TRIB ON DBO.EST_NF_ENT_IT.CD_TRIB = DBO.EST_TRIB.CD_TRIB
		 INNER JOIN DBO.EST_NF_SERIE ON DBO.EST_NF_ENT.CD_EMP = DBO.EST_NF_SERIE.CD_EMP
										AND DBO.EST_NF_ENT.CD_NF_SERIE = DBO.EST_NF_SERIE.CD_NF_SERIE
		 LEFT OUTER JOIN DBO.EST_NF_ENT_PED_CP ON DBO.EST_NF_ENT.CD_EMP = DBO.EST_NF_ENT_PED_CP.CD_EMP
												  AND DBO.EST_NF_ENT.CD_FILIAL = DBO.EST_NF_ENT_PED_CP.CD_FILIAL
												  AND DBO.EST_NF_ENT.CD_NF = DBO.EST_NF_ENT_PED_CP.CD_NF
		 LEFT OUTER JOIN EST_NF_ENT_DAR_IT ON EST_NF_ENT_IT.CD_EMP = EST_NF_ENT_DAR_IT.CD_EMP
											  AND EST_NF_ENT_IT.CD_FILIAL = EST_NF_ENT_DAR_IT.CD_FILIAL
											  AND EST_NF_ENT_IT.CD_NF = EST_NF_ENT_DAR_IT.CD_NF
											  AND EST_NF_ENT_IT.CD_PROD = EST_NF_ENT_DAR_IT.CD_PROD
		 INNER JOIN dbo.EST_PROD_EST_ARV_MERCADOLOGICA AS ARV ON EST_PROD.CD_EMP = ARV.CD_EMP
																 AND EST_PROD.CD_PROD = ARV.CD_PROD
		 INNER JOIN dbo.EST_ARV_MERC_LINHA AS L ON ARV.CD_EMP = L.CD_EMP
												   AND ARV.CD_ARV_MERC_LINHA = L.CD_ARV_MERC_LINHA
		 LEFT OUTER JOIN DBO.PRC_FILIAL_PG_FORN AS FF ON DBO.EST_NF_ENT.CD_EMP = FF.CD_EMP
														 AND DBO.EST_NF_ENT.CD_FORN = FF.CD_FORN
														 AND DBO.EST_NF_ENT.CD_FILIAL = FF.CD_FILIAL
		 LEFT JOIN dbo.V_EST_NF_ENT_NFE NFE ON dbo.EST_NF_ENT.CD_EMP = NFE.CD_EMP
											   AND dbo.EST_NF_ENT.CD_FILIAL = NFE.CD_FILIAL
											   AND dbo.EST_NF_ENT.CD_NF = NFE.CD_NF
		 LEFT JOIN dbo.EST_NF_ENT_NFE_CANCEL NFE_CANCEL ON dbo.EST_NF_ENT.CD_EMP = NFE_CANCEL.CD_EMP
														   AND dbo.EST_NF_ENT.CD_FILIAL = NFE_CANCEL.CD_FILIAL
														   AND dbo.EST_NF_ENT.CD_NF = NFE_CANCEL.CD_NF
		 LEFT JOIN EST_NF_ENT_DENEGADA NFE_DENEGADA ON dbo.EST_NF_ENT.CD_EMP = NFE_DENEGADA.CD_EMP
													   AND dbo.EST_NF_ENT.CD_FILIAL = NFE_DENEGADA.CD_FILIAL
													   AND dbo.EST_NF_ENT.CD_NF = NFE_DENEGADA.CD_NF
		 LEFT OUTER JOIN EST_NF_ENT_EF_NF_CTR_NF ON EST_NF_ENT_EF_NF_CTR_NF.CD_EMP = EST_NF_ENT.CD_EMP
													AND EST_NF_ENT_EF_NF_CTR_NF.CD_FILIAL = EST_NF_ENT.CD_FILIAL
													AND EST_NF_ENT_EF_NF_CTR_NF.CD_NF_ENT = EST_NF_ENT.CD_NF
                                                    
                                         
         LEFT  JOIN  EST_PROD_COD_BENEF  BN  ON 
           BN.CD_EMP    =EST_PROD.CD_EMP
           AND BN.CD_PROD    =EST_PROD.CD_PROD
           AND BN.UF   =EST_NF_ENT.UF_EMITENTE                                            
		 INNER JOIN GLB_USU ON EST_NF_ENT.CD_USU = GLB_USU.CD_USU
		 LEFT JOIN GLB_CID ON EST_NF_ENT.CD_CID_DESTINATARIO = GLB_CID.CD_CID
		 LEFT OUTER JOIN GLB_CID_GLB_MUNICIPIO ON GLB_CID.CD_CID = GLB_CID_GLB_MUNICIPIO.CD_CID
		 LEFT OUTER JOIN GLB_MUNICIPIO ON GLB_CID_GLB_MUNICIPIO.CD_MUNICIPIO = GLB_MUNICIPIO.CD_MUNICIPIO